/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity;

import dev.toma.gunsrpg.common.init.ModPotions;
import dev.toma.gunsrpg.common.init.ModTags;
import dev.toma.gunsrpg.util.Interval;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.Path;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ZombieNightmareEntity
extends MonsterEntity {
    private float healthLost;
    private boolean running;

    public ZombieNightmareEntity(EntityType<? extends MonsterEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 150.0).func_233815_a_(Attributes.field_233819_b_, 48.0).func_233815_a_(Attributes.field_233821_d_, 0.29).func_233815_a_(Attributes.field_233823_f_, 6.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new RecoverSelfGoal(this, 30.0f, 50.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new KnockDownPlayerGoal(this, ZombieNightmareEntity.companionFilter()));
        this.field_70714_bg.func_75776_a(3, (Goal)new NightmareMeleeAttackGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            while (this.healthLost >= 30.0f) {
                this.healthLost = -30.0f;
                this.spawnReinforcementMob();
            }
            if (this.field_70173_aa % 20 == 0) {
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 40, 2, false, false));
                this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g(20.0), ZombieNightmareEntity.companionFilter()).stream().map(entity -> (LivingEntity)entity).forEach(livingEntity -> {
                    livingEntity.func_195064_c(new EffectInstance(Effects.field_76429_m, 40, 0));
                    livingEntity.func_195064_c(new EffectInstance(Effects.field_76420_g, 40, 0));
                    livingEntity.func_70691_i(1.0f);
                });
            }
        }
    }

    public boolean func_70687_e(EffectInstance effect) {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187899_gZ;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187934_hh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(SoundEvents.field_187939_hm, 0.15f, 1.0f);
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    public boolean func_184638_cS() {
        return false;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData data, @Nullable CompoundNBT compoundNBT) {
        super.func_213386_a(world, difficulty, spawnReason, data, compoundNBT);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        return data;
    }

    protected void func_180481_a(DifficultyInstance diff) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151036_c));
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        boolean hurt = super.func_70097_a(damageSource, amount);
        if (hurt) {
            this.healthLost += amount;
        }
        return hurt;
    }

    public boolean func_70652_k(Entity target) {
        boolean attacked = super.func_70652_k(target);
        if (attacked && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.func_195064_c(new EffectInstance(Effects.field_76437_t, Interval.seconds(10).getTicks(), 0));
            living.func_195064_c(new EffectInstance(Effects.field_76421_d, Interval.seconds(10).getTicks(), 0));
        }
        return attacked;
    }

    protected void spawnReinforcements(int count) {
        for (int i = 0; i < count; ++i) {
            this.spawnReinforcementMob();
        }
    }

    protected void spawnReinforcementMob() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ServerWorld world = (ServerWorld)this.field_70170_p;
        ZombieEntity entity = new ZombieEntity(EntityType.field_200725_aD, this.field_70170_p);
        entity.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        entity.func_213386_a((IServerWorld)world, world.func_175649_E(this.func_233580_cy_()), SpawnReason.REINFORCEMENT, null, null);
        entity.func_70624_b(this.func_70638_az());
        this.field_70170_p.func_217376_c((Entity)entity);
    }

    public static Predicate<Entity> companionFilter() {
        return e -> e instanceof LivingEntity && e.func_200600_R().func_220341_a(ModTags.Entities.ZOMBIE_NIGHTMARE_COMPANIONS);
    }

    public void setRunning(boolean running) {
        this.func_70031_b(running);
        this.running = running;
    }

    private static final class KnockDownPlayerGoal
    extends Goal {
        private final ZombieNightmareEntity nightmareEntity;
        private final Predicate<Entity> selector;
        private boolean cancelled;
        private int refreshTimer;
        private Entity pickEntity;

        public KnockDownPlayerGoal(ZombieNightmareEntity nightmareEntity, Predicate<Entity> selector) {
            this.nightmareEntity = nightmareEntity;
            this.selector = e -> e.func_184187_bx() == null && selector.test((Entity)e);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (this.nightmareEntity.running || this.nightmareEntity.func_70638_az() == null) {
                return false;
            }
            List<Entity> pickableEntities = this.getEntitiesForPickup();
            if (pickableEntities.isEmpty()) {
                return false;
            }
            Path path = this.nightmareEntity.field_70699_by.func_75494_a((Entity)this.nightmareEntity.func_70638_az(), 0);
            return path != null && !path.func_224771_h();
        }

        public boolean func_75253_b() {
            if (this.nightmareEntity.func_70638_az() != null) {
                return !this.nightmareEntity.running && this.nightmareEntity.func_70638_az() != null && this.nightmareEntity.func_70638_az().func_70089_S() && !this.cancelled;
            }
            return false;
        }

        public void func_75249_e() {
            this.cancelled = false;
            this.refreshTimer = 0;
        }

        public void func_75251_c() {
            this.cancelled = true;
            if (this.nightmareEntity.func_70089_S() && this.nightmareEntity.func_184187_bx() == null) {
                this.nightmareEntity.func_184226_ay();
            }
        }

        public void func_75246_d() {
            if (--this.refreshTimer <= 0) {
                List heldEntities = this.nightmareEntity.func_184188_bt();
                if (heldEntities.isEmpty()) {
                    List<Entity> pickableEntities = this.getEntitiesForPickup();
                    if (pickableEntities.isEmpty()) {
                        this.cancelled = true;
                        this.refreshTimer = 20;
                        return;
                    }
                    if (this.pickEntity == null || !this.pickEntity.func_70089_S()) {
                        this.pickEntity = pickableEntities.get(this.nightmareEntity.field_70146_Z.nextInt(pickableEntities.size()));
                    }
                    this.nightmareEntity.field_70699_by.func_75497_a(this.pickEntity, 1.0);
                    double distance = this.nightmareEntity.func_70068_e(this.pickEntity);
                    if (distance < 16.0) {
                        this.pickEntity.func_184220_m((Entity)this.nightmareEntity);
                        this.pickEntity = null;
                    }
                } else {
                    LivingEntity target = this.nightmareEntity.func_70638_az();
                    if (target == null) {
                        this.cancelled = true;
                        return;
                    }
                    double distance = this.nightmareEntity.func_70068_e((Entity)target);
                    if (distance < 64.0) {
                        Vector3d vec = target.func_213322_ci();
                        double x = target.func_226277_ct_() + vec.field_72450_a - this.nightmareEntity.func_226277_ct_();
                        double y = target.func_226280_cw_() - (double)1.1f - this.nightmareEntity.func_226278_cu_();
                        double z = target.func_226281_cx_() + vec.field_72449_c - this.nightmareEntity.func_226281_cx_();
                        float dist = MathHelper.func_76133_a((double)(x * x + z * z));
                        for (Entity passenger : this.nightmareEntity.func_184188_bt()) {
                            passenger.func_184210_p();
                            this.throwEntityAtTarget(passenger, x, y + (double)(dist * 0.2f), z, 7.5f + this.nightmareEntity.field_70170_p.field_73012_v.nextFloat(), 0.6f);
                        }
                        this.cancelled = true;
                    }
                }
                this.refreshTimer = 20;
            }
        }

        private List<Entity> getEntitiesForPickup() {
            return this.nightmareEntity.field_70170_p.func_175674_a((Entity)this.nightmareEntity, this.nightmareEntity.func_174813_aQ().func_186662_g(24.0), this.selector);
        }

        private void throwEntityAtTarget(Entity entity, double x, double y, double z, float power, float multiplier) {
            if (entity instanceof MobEntity) {
                ((MobEntity)entity).func_70624_b(this.nightmareEntity.func_70638_az());
            }
            Random random = entity.field_70170_p.field_73012_v;
            float constant = 0.0075f;
            Vector3d delta = new Vector3d(x, y, z).func_72432_b().func_72441_c(random.nextGaussian() * (double)constant * (double)power, random.nextGaussian() * (double)constant * (double)power, random.nextGaussian() * (double)constant * (double)power).func_186678_a((double)multiplier);
            entity.func_213317_d(delta);
            float f = MathHelper.func_76133_a((double)Entity.func_213296_b((Vector3d)delta));
            entity.field_70177_z = (float)(MathHelper.func_181159_b((double)delta.field_72450_a, (double)delta.field_72449_c) * 57.2957763671875);
            entity.field_70125_A = (float)(MathHelper.func_181159_b((double)delta.field_72448_b, (double)f) * 57.2957763671875);
            entity.field_70126_B = entity.field_70177_z;
            entity.field_70127_C = entity.field_70125_A;
        }
    }

    private static final class NightmareMeleeAttackGoal
    extends MeleeAttackGoal {
        public NightmareMeleeAttackGoal(ZombieNightmareEntity entity, double speed, boolean followHidden) {
            super((CreatureEntity)entity, speed, followHidden);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !((ZombieNightmareEntity)this.field_75441_b).running;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !((ZombieNightmareEntity)this.field_75441_b).running;
        }
    }

    private static final class RecoverSelfGoal
    extends Goal {
        private final ZombieNightmareEntity nightmareEntity;
        private final float initiateAtHealth;
        private final float stopAtHealth;
        private boolean active;
        private int taskCooldown;
        private LivingEntity lastTarget;

        public RecoverSelfGoal(ZombieNightmareEntity nightmareEntity, float initiateAtHealth, float stopAtHealth) {
            this.nightmareEntity = nightmareEntity;
            this.initiateAtHealth = initiateAtHealth;
            this.stopAtHealth = stopAtHealth;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return !this.active && this.nightmareEntity.func_110143_aJ() <= this.initiateAtHealth && this.nightmareEntity.func_70643_av() != null && this.taskCooldown <= 0;
        }

        public boolean func_75253_b() {
            return this.active && this.nightmareEntity.func_110143_aJ() < this.stopAtHealth && this.lastTarget != null && this.lastTarget.func_70089_S();
        }

        public void func_75249_e() {
            this.active = true;
            this.nightmareEntity.setRunning(true);
            this.nightmareEntity.func_70624_b(null);
            this.nightmareEntity.field_70699_by.func_75499_g();
            this.throwPotionIfApplicable();
            this.runAway();
            this.nightmareEntity.spawnReinforcements(3);
            this.nightmareEntity.field_70170_p.func_175674_a((Entity)this.nightmareEntity, this.nightmareEntity.func_174813_aQ().func_186662_g(60.0), ZombieNightmareEntity.companionFilter()).stream().filter(entity -> entity instanceof MonsterEntity).map(entity -> (MonsterEntity)entity).forEach(entity -> {
                entity.func_70624_b(this.nightmareEntity.func_70638_az());
                entity.func_195064_c(new EffectInstance(Effects.field_76424_c, Integer.MAX_VALUE, 1, false, true));
            });
            this.taskCooldown = Interval.minutes(2).getTicks();
            this.lastTarget = this.nightmareEntity.func_70643_av();
        }

        public void func_75251_c() {
            this.active = false;
            this.nightmareEntity.setRunning(false);
            this.lastTarget = null;
        }

        public void func_75246_d() {
            if (this.taskCooldown > 0) {
                --this.taskCooldown;
            }
            this.runAway();
        }

        private void runAway() {
            if (this.lastTarget != null) {
                Path path = this.nightmareEntity.field_70699_by.func_75505_d();
                if (path == null || !path.func_75879_b() || !path.func_224771_h()) {
                    Vector3d hidePosition = RandomPositionGenerator.func_75461_b((CreatureEntity)this.nightmareEntity, (int)16, (int)7, (Vector3d)this.lastTarget.func_213303_ch());
                    if (hidePosition != null && this.lastTarget.func_195048_a(hidePosition) > this.nightmareEntity.func_195048_a(hidePosition)) {
                        this.nightmareEntity.func_70661_as().func_75492_a(hidePosition.field_72450_a, hidePosition.field_72448_b, hidePosition.field_72449_c, (double)1.3f);
                        this.nightmareEntity.func_70031_b(true);
                    } else {
                        this.nightmareEntity.func_70031_b(false);
                    }
                } else {
                    this.nightmareEntity.field_70699_by.func_75484_a(path, (double)1.3f);
                }
            }
        }

        private void throwPotionIfApplicable() {
            if (this.nightmareEntity.field_70170_p.field_72995_K) {
                return;
            }
            LivingEntity attacker = this.nightmareEntity.func_70643_av();
            if (attacker != null && this.nightmareEntity.func_70068_e((Entity)attacker) < 64.0) {
                Vector3d vec = attacker.func_213322_ci();
                double x = attacker.func_226277_ct_() + vec.field_72450_a - this.nightmareEntity.func_226277_ct_();
                double y = attacker.func_226280_cw_() - (double)1.1f - this.nightmareEntity.func_226278_cu_();
                double z = attacker.func_226281_cx_() + vec.field_72449_c - this.nightmareEntity.func_226281_cx_();
                float dist = MathHelper.func_76133_a((double)(x * x + z * z));
                PotionEntity potionentity = new PotionEntity(this.nightmareEntity.field_70170_p, (LivingEntity)this.nightmareEntity);
                potionentity.func_213884_b(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)((Potion)ModPotions.ZOMBIE_NIGHTMARE_DEFENSIVE_POTION.get())));
                potionentity.field_70125_A -= -20.0f;
                potionentity.func_70186_c(x, y + (double)(dist * 0.2f), z, 0.4f, 8.0f);
                if (!this.nightmareEntity.func_174814_R()) {
                    this.nightmareEntity.field_70170_p.func_184148_a(null, this.nightmareEntity.func_226277_ct_(), this.nightmareEntity.func_226278_cu_(), this.nightmareEntity.func_226281_cx_(), SoundEvents.field_187924_gx, this.nightmareEntity.func_184176_by(), 1.0f, 0.8f + this.nightmareEntity.field_70146_Z.nextFloat() * 0.4f);
                }
                this.nightmareEntity.field_70170_p.func_217376_c((Entity)potionentity);
            }
        }
    }
}

